<?php
/**
 * Branda PRO upgrade page.
 *
 * @since 3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} ?>

<div class="sui-upgrade-page">
	<div class="sui-upgrade-page-header">
		<div class="sui-upgrade-page__container">
			<div class="sui-upgrade-page-header__content">
				<h1><?php esc_html_e( 'Upgrade to Branda Pro', 'ub' ); ?></h1>
				<p><?php esc_html_e( 'Get everything you need to white label your sites with Branda Pro.', 'ub' ); ?></p>
				<p><?php esc_html_e( 'Plus – you\'ll get a WPMU DEV membership, which includes white label reports, early access to new features in Branda, award-winning image optimization with Smush Pro, 24/7 live support for all things WordPress, unlimited usage of all our premium plugins, managed hosting credits, and more.', 'ub' ); ?></p>
				<a href="https://wpmudev.com/project/ultimate-branding/?utm_source=branda&utm_medium=plugin&utm_campaign=branda_propage_topbutton" class="sui-button sui-button-lg sui-button-purple" target="_blank">
					<?php esc_html_e( 'TRY BRANDA PRO FOR FREE', 'ub' ); ?>
				</a>
				<div class="sui-reviews">
					<span class="sui-reviews__stars"></span>
					<div class="sui-reviews__rating"><span class="sui-reviews-rating">-</span> / <?php esc_html_e( '5.0 rating from', 'ub' ); ?> <span class="sui-reviews-customer-count">-</span> <?php esc_html_e( 'customers', 'ub' ); ?></div>
					<a class="sui-reviews__link" href="https://www.reviews.io/company-reviews/store/wpmudev-org" target="_blank">
						Reviews.io<i class="sui-icon-arrow-right" aria-hidden="true"></i>
					</a>
				</div>
			</div>

			<div class="sui-upgrade-page-header__image"></div>
		</div>
	</div>
	<div class="sui-upgrade-page-features">
		<div class="sui-upgrade-page-features__header">
			<h2><?php esc_html_e( 'Pro Features', 'ub' ); ?></h2>
			<p><?php esc_html_e( 'Upgrading to Pro will get you the following benefits.', 'ub' ); ?></p>
		</div>
	</div>
	<div class="sui-upgrade-page__container">
		<div class="sui-upgrade-page-features__items">
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-mail" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'SMTP email logging', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'Get detailed information about your emails with Branda Pro. Track information about your recipients and view and export log history.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-graph-bar" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'White label automated reporting', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'Customize, style, schedule and send white label client and developer reports in just a few clicks with embedded performance, security, SEO, and analytics data.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-smush" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'Smush Pro and Hummingbird Pro - the ultimate site optimization & performance package', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'Smush’s award-winning image optimization + Hummingbird’s performance optimization gives you the fastest possible WordPress site. It’s a powerful combination that your visitors, customers, and search engines will love.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-gdpr" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'Premium WordPress plugins', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'In addition to Branda Pro, you\'ll get our full suite of premium WordPress plugins. From security to backups to marketing and SEO, you\'ve got all the WordPress solutions you\'ll need to build, promote and manage your website. Get access to unlimited usage across all your sites. Join more than 1 million users with our plugins.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-hub" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'The Hub - Manage unlimited WordPress sites', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'You can manage unlimited WordPress sites with automated updates, backups, security, and performance checks, all in one place. All of this can be white labeled for your clients, and you even get our 24/7 live WordPress support.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-help-support" aria-hidden="true"></i>
				<h3><?php esc_html_e( '24/7 live WordPress support', 'ub' ); ?></h3>
				<p><?php esc_html_e( 'We can’t stress this enough: our outstanding WordPress support is available with live chat 24/7, and we’ll help you with absolutely any WordPress issue – not just our products. It’s an expert WordPress team on call for you, whenever you need them.', 'ub' ); ?></p>
			</div>
			<div class="sui-upgrade-page-features__item">
				<i class="sui-icon-wpmudev-logo" aria-hidden="true"></i>
				<h3><?php esc_html_e( 'The WPMU DEV Guarantee', 'ub' ); ?></h3>
				<p><?php esc_html_e( "You'll be delighted with Branda Pro and everything else included in your membership 😁 You've got a no risk free trial to test the WPMU DEV Membership, and if you continue but change your mind, you can cancel any time.", 'ub' ); ?></p>
			</div>
		</div>
	</div>
	<div class="sui-upgrade-page-cta">
		<div class="sui-upgrade-page-cta__inner">
			<h2><?php esc_html_e( 'Join 771,093 Happy Members', 'ub' ); ?></h2>
			<p><?php esc_html_e( "97% of customers are happy with WPMU DEV's service, and it’s a great time to join them: as a Branda user you’ll get a free trial, so you can see what all the fuss is about.", 'ub' ); ?></p>
			<button onclick="window.open('https://wpmudev.com/project/ultimate-branding/?utm_source=branda&utm_medium=plugin&utm_campaign=branda_propage_bottombutton')" class="sui-button sui-button-lg sui-button-purple" target="_blank">
				<?php esc_html_e( 'Get Branda Pro and get a better WordPress', 'ub' ); ?>
			</button>
			<button type="button" class="sui-button sui-button-lg sui-button-purple sui-hidden-desktop">
				<?php esc_html_e( 'Get Branda Pro', 'ub' ); ?>
			</button>
			<a href="https://wpmudev.com/project/ultimate-branding/?utm_source=branda&utm_medium=plugin&utm_campaign=branda_propage_bottombutton" target="_blank">
				<?php esc_html_e( 'Try it for free', 'ub' ); ?>
			</a>
		</div>
	</div>
</div>
